/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.panonrmi;

import filenet.pa.datacollector.PEEventLog;
import filenet.pa.sql.ExposedField;
import filenet.pa.sql.PAPEPartition;
import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.pa.panonrmi.IPANonRMI;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.List;

public class PANonRMIImpl
implements IPANonRMI {
    private ClassLoader m_classLoader = null;
    private Object m_paAdmin = null;

    protected PANonRMIImpl(ClassLoader classLoader, ClassLoader fnolapClassLoader) throws Exception {
        this.m_classLoader = classLoader;
        Class<?> paAdminClass = this.m_classLoader.loadClass("filenet.pa.admin.PAAdministrationNonRMI");
        this.m_paAdmin = paAdminClass.getConstructor(ClassLoader.class).newInstance(fnolapClassLoader);
    }

    public PEEventLog[] getPEEventLogs() throws Exception {
        Object[] arr = (Object[])this.execute("getPEEventLogs", null, null);
        if (arr == null) {
            return null;
        }
        PEEventLog[] logs = new PEEventLog[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Object log = arr[i];
            logs[i] = new PEEventLog((String)log.getClass().getMethod("getName", null).invoke(log, null), ((Integer)log.getClass().getMethod("getRegion", null).invoke(log, null)).intValue());
        }
        return logs;
    }

    public boolean isPAPEPartitionEnabled() throws Exception {
        return (Boolean)this.execute("isPAPEPartitionEnabled", null, null);
    }

    public void updatePAPEPartitions(PAPEPartition[] selected, PAPEPartition[] deSelected) throws Exception {
        Object[] _selected = this.copyPAPEPartitionArray(selected);
        Object[] _deSelected = this.copyPAPEPartitionArray(deSelected);
        Class<?> partitionArrayClass = _selected.getClass();
        Class[] paramTypes = new Class[]{partitionArrayClass, partitionArrayClass};
        Object[] args = new Object[]{_selected, _deSelected};
        this.execute("updatePAPEPartitions", paramTypes, args);
    }

    private Object[] copyPAPEPartitionArray(PAPEPartition[] source) throws Exception {
        Class<?> partitionClass = this.m_classLoader.loadClass("filenet.pa.sql.PAPEPartition");
        Object[] target = (Object[])Array.newInstance(partitionClass, source.length);
        Class[] paramTypes = new Class[]{Integer.TYPE, String.class};
        Constructor<?> c = partitionClass.getConstructor(paramTypes);
        for (int i = 0; i < source.length; ++i) {
            Object[] args = new Object[]{new Integer(source[i].getRegionId()), source[i].getEventLog()};
            target[i] = c.newInstance(args);
        }
        return target;
    }

    public PAPEPartition[] getPAPEPartitions() throws Exception {
        Object[] arr = (Object[])this.execute("getPAPEPartitions", null, null);
        if (arr == null) {
            return null;
        }
        PAPEPartition[] partitions = new PAPEPartition[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Object p = arr[i];
            partitions[i] = new PAPEPartition(((Integer)p.getClass().getMethod("getRegionId", null).invoke(p, null)).intValue(), (String)p.getClass().getMethod("getEventLog", null).invoke(p, null));
        }
        return partitions;
    }

    public ExposedField[] getExposedDataFields() throws Exception {
        Object[] arr = (Object[])this.execute("getExposedDataFields", null, null);
        if (arr == null) {
            return null;
        }
        ExposedField[] fields = new ExposedField[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Object field = arr[i];
            Object objFieldType = field.getClass().getMethod("getType", null).invoke(field, null);
            Class<?> fieldTypeClass = this.m_classLoader.loadClass("filenet.pa.sql.ExposedField$Type");
            String fieldType = (String)fieldTypeClass.getMethod("getName", null).invoke(objFieldType, null);
            fields[i] = new ExposedField((String)field.getClass().getMethod("getUniqueName", null).invoke(field, null), (String)field.getClass().getMethod("get_FieldName", null).invoke(field, null), fieldType, ((Boolean)field.getClass().getMethod("isMeasure", null).invoke(field, null)).booleanValue(), (List)field.getClass().getMethod("getRanges", null).invoke(field, null), ((Integer)field.getClass().getMethod("getCubesValue", null).invoke(field, null)).intValue(), ((Integer)field.getClass().getMethod("getCubeOptions", null).invoke(field, null)).intValue());
        }
        return fields;
    }

    public void exposeDataField(String uniqueName, String fieldName, int fieldType, boolean bMeasure, int cubes, int cubeOptions, Object[] ranges) throws Exception {
        Class[] paramTypes = new Class[]{String.class, String.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Object[].class};
        Object[] args = new Object[]{uniqueName, fieldName, new Integer(fieldType), new Boolean(bMeasure), new Integer(cubes), new Integer(cubeOptions), ranges};
        this.execute("exposeDataField", paramTypes, args);
    }

    public void disposeDataField(String name) throws Exception {
        this.execute("disposeDataField", new Class[]{String.class}, new Object[]{name});
    }

    public void updateDataField(String uniqueNameOrig, String uniqueNameMod, String fieldName, int cubes, int cubeOptions) throws Exception {
        Class[] paramTypes = new Class[]{String.class, String.class, String.class, Integer.TYPE, Integer.TYPE};
        Object[] args = new Object[]{uniqueNameOrig, uniqueNameMod, fieldName, new Integer(cubes), new Integer(cubeOptions)};
        this.execute("updateDataField", paramTypes, args);
    }

    public String exportUDF() throws Exception {
        return (String)this.execute("exportUDF", new Class[0], new Object[0]);
    }

    public void importUDF(String xml) throws Exception {
        this.execute("importUDF", new Class[]{String.class}, new Object[]{xml});
    }

    public void changeAdjustedMeasuresSetting(boolean bShowAdjustments) throws Exception {
        this.execute("changeAdjustedMeasuresSetting", new Class[]{Boolean.TYPE}, new Object[]{new Boolean(bShowAdjustments)});
    }

    private Object execute(String methodName, Class[] paramTypes, Object[] args) throws Exception {
        try {
            Method method = this.m_paAdmin.getClass().getMethod(methodName, paramTypes);
            return method.invoke(this.m_paAdmin, args);
        }
        catch (Exception ex) {
            this.throwException(ex);
            return null;
        }
    }

    private void throwException(Exception ex) throws Exception {
        if (ex instanceof InvocationTargetException) {
            Throwable target = ((InvocationTargetException)ex).getTargetException();
            if (target instanceof NoClassDefFoundError) {
                VWException vwEx = new VWException("filenet.vw.apps.taskman.pa.PANonRMIImpl.NoClassDefFoundError", "Please verify the JDBC properties for connecting to the Case Analyzer database.");
                vwEx.setCause(target);
                throw vwEx;
            }
            if (target instanceof SQLException) {
                VWException vwEx = new VWException("filenet.vw.apps.taskman.pa.PANonRMIImpl.SQLException", "A database connection could not be established.  Please check the following properties and make corrections if necessary:\n\n- The database host \n- The database instance name (if you installed to a named instance) \n- The database port number \n- The database user name \n- The database password");
                vwEx.setCause(target);
                throw vwEx;
            }
            if (target instanceof Exception) {
                throw (Exception)target;
            }
        }
        throw ex;
    }
}

